(async () => {
  const div = document.querySelector("#graphique1"); // Conteneur du graphique

  if (div) {
      try {
          const sortedThemesResponse = await fetch(monGraphiqueData.sorted_themes);
          const sortedThemes = await sortedThemesResponse.json();

          const filteredDataResponse = await fetch(monGraphiqueData.filtered_data);
          const filteredData = await filteredDataResponse.json();

          // Extraire les départements uniques pour remplir le sélecteur
          const uniqueDepartments = [...new Set(filteredData.map(museum => museum.Departement))];

          // Créer le sélecteur (dropdown) et l'ajouter avant le graphique
          const select = document.createElement("select");
          select.style.marginBottom = "10px";
          select.style.width = "100%";
          select.style.padding = "5px";
          
          // Ajouter l'option "Tous les Départements" par défaut
          const defaultOption = document.createElement("option");
          defaultOption.textContent = "Tous";
          defaultOption.value = "Tous";
          select.appendChild(defaultOption);
          
          // Ajouter les options pour chaque département
          uniqueDepartments.forEach(departement => {
              const option = document.createElement("option");
              option.textContent = departement;
              option.value = departement;
              select.appendChild(option);
          });
          
          // Insérer le sélecteur au-dessus du graphique
          div.parentNode.insertBefore(select, div);

          const formatYear = d3.format("d");

          // Couleurs pour chaque thématique
          const colorScale = d3.scaleOrdinal()
              .domain(sortedThemes.map(d => d.Theme))
              .range(d3.schemeCategory10);  // Palette de 10 couleurs prédéfinies

          // Fonction pour dessiner le graphique
          const drawGraph = (filteredMuseums) => {
              const plot = Plot.plot({
                  title: "Top 15 des Thématiques les Plus Récurrentes en France",
                  marginLeft: 60,
                  marginRight: 120,
                  marginBottom: 100,
                  marginTop: 50,
                  width: 800,
                  height: 500,
                  x: {
                      label: "Thématiques",
                      domain: filteredMuseums.map(d => d.Theme).slice(0, 15),
                      tickRotate: -30
                  },
                  y: {
                      label: "Nombre de musées",
                      grid: true
                  },
                  color: {
                      type: "ordinal",
                      domain: filteredMuseums.map(d => d.Theme),
                      range: colorScale.range(),  // Utiliser les couleurs définies
                      legend: true,  // Afficher la légende des couleurs
                      label: "Thématiques"
                  },
                  marks: [
                      Plot.barY(filteredMuseums.slice(0, 15), {
                          x: "Theme",
                          y: "Count",
                          fill: d => colorScale(d.Theme),  // Appliquer les couleurs
                          stroke: "black",  // Ajout du contour noir
                          strokeWidth: 0.3,  // Épaisseur du contour
                          title: d => `${d.Theme}: ${d.Count} musées`
                      })
                  ]
              });

              // Vider le contenu avant d'ajouter le graphique
              div.innerHTML = '';
              div.appendChild(plot);
          };

          // Fonction pour filtrer les musées par département
          const filterMuseums = () => {
              const selectedDepartement = select.value;
              const filteredMuseums = selectedDepartement === "Tous"
                  ? sortedThemes
                  : filteredData.filter(museum => museum.Departement === selectedDepartement);

              // Vérifier que des musées existent pour ce département
              if (filteredMuseums.length > 0) {
                  drawGraph(filteredMuseums);
              } else {
                  div.innerHTML = "<p>Aucun musée trouvé pour ce département.</p>";
              }
          };

          // Afficher le graphique initial avec toutes les données
          drawGraph(sortedThemes);

          // Ajouter un événement pour redessiner le graphique lorsqu'un département est sélectionné
          select.addEventListener('change', filterMuseums);

      } catch (error) {
          console.error('Erreur lors du chargement des données :', error);
      }
  } else {
      console.error("Pas trouvé d'élément avec l'ID 'graphique1'");
  }
})();
