<?php
/**
 * Plugin Name: Mon Graphique Interactif
 * Description: Affiche un graphique interactif des thématiques des musées.
 * Version: 1.0
 * Author: Your Name
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function register_plot_graphique_scripts() {
    wp_register_script('d3', 'https://cdn.jsdelivr.net/npm/d3@7', null, '7.0', true);
    wp_register_script('plot', 'https://cdn.jsdelivr.net/npm/@observablehq/plot@0.6', array('d3'), '0.6', true);
    wp_enqueue_script('plot-graphique', plugins_url('graphique1.js', __FILE__), array('plot'), '1.0', true);
    
    // Localisation des fichiers JSON
    wp_localize_script('plot-graphique', 'monGraphiqueData', array(
        'sorted_themes' => plugins_url('sortedThemes.json', __FILE__),
        'filtered_data' => plugins_url('filteredData.json', __FILE__)
    ));
}
add_action('wp_enqueue_scripts', 'register_plot_graphique_scripts');

function mon_graphique_interactif_shortcode() {
    ob_start();
    ?>
    <div id="input-temp"></div>
    <div id="graphique1"></div>
    <?php
    return ob_get_clean();
}
add_shortcode('mon_graphique_interactif', 'mon_graphique_interactif_shortcode');
